/*
Copyright (C) 2010 Edge-Core Networks
This software file (the "File") is owned and distributed by 
Edge-Core Networks under the following licensing terms.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston,
MA 02111-1307 USA
*/

#ifndef _AMS_PART_FIXED_H_
#define _AMS_PART_FIXED_H_

#define DEVICE_NOR_NAME             "nor"
#define DEVICE_NAND_NAME            "nand"
#define DEVICE_CF_NAME              "cfcard"
#define DEVICE_SPI_NAME             "spi"

#include "ams_common.h"


#include "../sysinclude/core_fs.h"
#include "../sysinclude/ams_part.h"

/* functon description */
unsigned long AMS_PART_get_device_type(const char *device_name, AMS_PARTITION_DEVICE_TYPE_T *device_type);
unsigned long AMS_PART_get_filemapping(unsigned long index, AMS_FILEMAPPING_T *filemapping_ptr);
unsigned long AMS_PART_get_filemapping_region(FlashRegion_T *region_ptr);
unsigned long AMS_PART_init_filemapping(unsigned long index, AMS_FILEMAPPING_T *filemapping_ptr);
unsigned long AMS_PART_get_partition_table_ptr(AMS_PARTITION_TABLE_T **ptr);
unsigned long AMS_PART_get_filemapping_mgr_ptr(AMS_FILEMAPPING_MGR_T **ptr);
unsigned long AMS_PART_check_active(unsigned long index, AMS_PARTITION_TYPE_T type);
unsigned long AMS_PART_get_startup_by_type(AMS_PARTITION_TYPE_T type,  unsigned long *partiton_idx);
unsigned long AMS_PART_get_info_by_index(unsigned long index, unsigned long *addr, unsigned long *size);
unsigned long AMS_PART_get_info_by_type(AMS_PARTITION_TYPE_T type, unsigned long *addr, unsigned long *size, unsigned long part_index, AMS_PARTITION_DEVICE_TYPE_T *device_type);
unsigned long AMS_PART_set_part_info_by_index(unsigned long part_idx, const char *name, unsigned long file_size, AMS_PARTITION_TYPE_T type);
unsigned long AMS_PART_get_info_by_name(unsigned char *name, unsigned long *addr, unsigned long *size, AMS_PARTITION_TYPE_T *type);
unsigned long AMS_PART_get_info_by_filename(const char *filename, unsigned long *addr, unsigned long *size, unsigned long *part_idx, AMS_PARTITION_DEVICE_TYPE_T *device_type);
unsigned long CheckSum(unsigned long start_addr, unsigned long length);
unsigned long AMS_PART_get_partition_filename(unsigned long index, unsigned char *file_name, unsigned long *file_length);
unsigned long AMS_PART_write_part2flash(AMS_PARTITION_TABLE_T *partition_table_ptr);
unsigned long AMS_PART_write_filemapping2flash(AMS_FILEMAPPING_MGR_T *filemapping_mgr);
unsigned long AMS_PART_get_region(unsigned long index, FlashRegion_T *region);
unsigned long AMS_PART_check_partition(void);
unsigned long AMS_PART_write_to_device(AMS_PARTITION_TYPE_T type, const char *name, unsigned long addr, unsigned long length, unsigned long part_index);
unsigned long AMS_PART_read_from_device(AMS_PARTITION_TYPE_T type, const char *name, unsigned long length, unsigned long *buf_addr);
unsigned long AMS_PART_get_boot_part( AMS_PARTITION_TYPE_T type,unsigned long *active_part_idx);

/*-------------------------------------------------------------------------
 * FUNCTION NAME - AMS_PART_get_inactive_part
 * ------------------------------------------------------------------------
 * PURPOSE  :   Get index of the inactive partition with specific type.
 * INPUT    :   type = partition type
 * OUTPUT   :   part_idx = index of the partition. 
 * RETURN   :   
 *              RC_OK = Success
 *              <others> = Fail
 * NOTES    :   None
 * ------------------------------------------------------------------------
 */
int AMS_PART_get_inactive_part(AMS_PARTITION_TYPE_T type, unsigned long *part_idx);

//unsigned long AMS_PART_get_region_mode(FlashRegion_T* region);

/* ------------------------------------------------------------------------
 * FUNCTION NAME: AMS_PART_get_non_startup_filename
 * PURPOSE  : get the inactive file of a given type.
 * INPUT    : file_type   -- the type of file
 * OUTPUT   : 
 *            file_name   -- the file name 
 *            file_length -- the size of file.
 * RETURN   : 
 *            RC_OK    = Success
 *            RC_ERROR = Fail
 * NOTES    : None
 * ------------------------------------------------------------------------
 */
int AMS_PART_get_non_startup_filename(AMS_PARTITION_TYPE_T file_type, unsigned char *file_name, unsigned long *file_length);

/* ------------------------------------------------------------------------
 * FUNCTION NAME: AMS_PART_get_startup_filename
 * PURPOSE  : get the startup file of a given type.
 * INPUT    : 
 *            file_type   -- the type of file
 * OUTPUT   :
 *            file_name   -- the file name 
 *            file_length -- the size of file.
 * RETURN   :
 *            RC_OK    = Success
 *            RC_ERROR = Fail
 * NOTES    : None
 * ------------------------------------------------------------------------
 */
int AMS_PART_get_startup_filename(AMS_PARTITION_TYPE_T file_type, unsigned char *file_name, unsigned long *file_length);

/* ------------------------------------------------------------------------
 * FUNCTION NAME: AMS_PART_recover_runtime_to_default
 * PURPOSE  :   Recover runtime file information and
 *              write the default file name, size.
 *              Bootable runtime image will be loaded at LA_DB_ADDR if it is
 *              recovered successfully.
 * INPUT    :   None
 * OUTPUT   :   None
 * RETURN   :   
 *              RC_OK    = Success
 *              RC_ERROR = Fail
 *
 * NOTES    :   This function shall check the runtime file in flash first.
 *              If runtime's checksum is correct, then using default file name.
 *              If there is environment "runtimename", get file name from "runtimename".
 *              Otherwise, runtime file name is the partition name with extension ".bix".
 *
 *              If runtime's checksum is not correct, then check next runtime file.
 * ------------------------------------------------------------------------
 */
int AMS_PART_recover_runtime_to_default(void);

/* ------------------------------------------------------------------------
 * FUNCTION NAME: AMS_PART_validate_and_load_boot_runtime
 * PURPOSE  :   Validate the startup runtime image(the runtime image set as active)
 *              The runtime image will be loaded to LA_DB_ADDR after returning
 *              from this function if there is no error.
 * INPUT    :   None
 * OUTPUT   :   None
 * RETURN   :   
 *              RC_OK    = Success
 *              RC_ERROR = Fail
 *
 * NOTES    : 1.This function will validate the startup runtime image through
 *              image header checksum and image data checksum. The runtime
 *              image will be loaded to LA_DB_ADDR if there is no error.
 *            2.Invalid runtime image will be deleted from file mapping table.
 * ------------------------------------------------------------------------
 */
int AMS_PART_validate_and_load_boot_runtime(void);

/* ------------------------------------------------------------------------
 * FUNCTION NAME: AMS_PART_delete_runtime_file
 * PURPOSE:	delete runtime file in flash device.
 * INPUT:	file name
 * OUTPUT:	None
 * RETURN:	
 *              RC_OK    = Success
 *              RC_ERROR = Fail
 * NOTES:
 * ------------------------------------------------------------------------
 */
int AMS_PART_delete_runtime_file(char *file_name);

/* ------------------------------------------------------------------------
 * FUNCTION NAME: AMS_PART_prepare_runtime_image
 * PURPOSE:	Check file partition table and select a bootable runtime image.
 *          If a bootable runtime image is not available, this function will
 *          try to recover a usable runtime image in flash through the
 *          validation of checksum.
 * INPUT:	None
 * OUTPUT:	boot_runtime_filename -- the filename of the runtime that is
 *                                   being used to boot up.
 *                                   The size of boot_runtime_filename must be
 *                                   greater or equal to PART_FILE_NAMELEN.
 * RETURN:	RC_OK    = Success
 *          RC_ERROR = Fail (No runtime image availabe for boot)
 * NOTES: 1.If RC_OK is returned, the bootable runtime image will be loaded
 *          at LA_DB_ADDR.
 *        2.Invalid runtime will be deleted from file mapping table.
 *        3.The startup runtime could be changed if the original startup
 *          runtime image is invalid.
 * ------------------------------------------------------------------------
 */
int AMS_PART_prepare_runtime_image(char* boot_runtime_filename);

/* software flash chip selection */
#ifdef CONFIG_AMS_FLASH_CS
extern ulong OEM_flash_v2p(ulong address);
#define AMS_FLASH_MAPPING(addr)     { addr = OEM_flash_v2p(addr); }
#define AMS_FLASH_DEFAULT()         OEM_flash_v2p(CFG_FLASH_BASE)
#else /* #ifdef CONFIG_AMS_FLASH_CS */
#define OEM_flash_v2p(address) ({address;})
#define AMS_FLASH_MAPPING(addr)
#define AMS_FLASH_DEFAULT()
#endif /* end of #ifdef CONFIG_AMS_FLASH_CS */

#endif /* end of #ifndef _AMS_PART_FIXED_H_ */

